function out=hfuncNC(u,v,rho)
% this function calculates the h function of the Normal Copula as
% introduced in Aas et al:"Pair - copula constructions of multiple
% dependence"
% INPUTS:
% u,v:          uniform variables
% rho:          the corr coefficient of u and v
% error checking
if max(u)>1 || min(u)<0
    error('u and v are uniform')
end
if max(v)>1 || min(v)<0
    error('u and v are uniform')
end
if nargin==2
    rankcorr=corr(u,v,'type','Kendall');
    rankcorr=rankcorr(1,2);
    rho=sin(rankcorr*pi/2);
end
[R,C]=size(rho);
if R>2 || C>2
    error('rho is a scalar in (-1,1) or a 2x2 pd matrix')
elseif R==2 && C==2
    rho=rho(1,2);
end
out1=norminv(u)-rho*norminv(v);
out=normcdf(out1/sqrt(1-rho^2));